% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flist.R
\name{read.flist}
\alias{read.flist}
\title{Read a formatting list from the file system}
\usage{
read.flist(file_path)
}
\arguments{
\item{file_path}{The path to the formatting list.}
}
\value{
The formatting list as an R object.
}
\description{
The \code{read.flist} function reads a formatting list
from the file system.  The function accepts a path to the formatting list,
reads the list, and returns it.
}
\examples{
# Create formatting list
fl <- flist(f1 = "\%5.1f",
            f2 = "\%6.2f",
            type = "row")
           
# Get temp directory
tmp <- tempdir()            
           
# Save formatting list to file system
pth <- write.flist(fl, dir_path = tmp)

# Read from file system
fr <- read.flist(pth)

# Create sample data
dat <- c(12.3844, 292.28432)

# Use formats in the catalog
fapply(dat, fr)
# [1] " 12.4"  "292.28"
}
\seealso{
Other flist: 
\code{\link{as.data.frame.fmt_lst}()},
\code{\link{as.flist}()},
\code{\link{as.flist.data.frame}()},
\code{\link{as.flist.fcat}()},
\code{\link{as.flist.list}()},
\code{\link{as.flist.tbl_df}()},
\code{\link{flist}()},
\code{\link{is.flist}()},
\code{\link{print.fmt_lst}()},
\code{\link{write.flist}()}
}
\concept{flist}
