% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/AllMethods.R
\docType{methods}
\name{ncov}
\alias{ncov}
\alias{ncov,fmrsfit-method}
\alias{ncov,ncov-method}
\title{ncov method}
\usage{
ncov(object, ...)

\S4method{ncov}{fmrsfit}(object, ...)
}
\arguments{
\item{object}{An \code{\link{fmrsfit-class}}}

\item{...}{Other possible arguments}
}
\value{
An integer value
}
\description{
Provides the number of covariates of an FMRs model from
an \code{\link{fmrsfit-class}}
}
\examples{
set.seed(1980)
nComp = 2
nCov = 10
nObs = 500
dispersion = c(1, 1)
mixProp = c(0.4, 0.6)
rho = 0.5
coeff1 = c( 2,  2, -1, -2, 1, 2, 0, 0,  0, 0,  0)
coeff2 = c(-1, -1,  1,  2, 0, 0, 0, 0, -1, 2, -2)
umax = 40

dat <- fmrs.gendata(nObs = nObs, nComp = nComp, nCov = nCov,
                     coeff = c(coeff1, coeff2), dispersion = dispersion,
                     mixProp = mixProp, rho = rho, umax = umax,
                     disFamily = "lnorm")

res.mle <- fmrs.mle(y = dat$y, x = dat$x, delta = dat$delta,
                   nComp = nComp, disFamily = "lnorm",
                   initCoeff = rnorm(nComp*nCov+nComp),
                   initDispersion = rep(1, nComp),
                   initmixProp = rep(1/nComp, nComp))
ncov(res.mle)
}
\author{
Farhad Shokoohi <shokoohi@icloud.com>
}

