% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{fm_row_kron}
\alias{fm_row_kron}
\title{Row-wise Kronecker products}
\usage{
fm_row_kron(M1, M2, repl = NULL, n.repl = NULL, weights = NULL)
}
\arguments{
\item{M1}{A matrix that can be transformed into a sparse Matrix.}

\item{M2}{A matrix that can be transformed into a sparse Matrix.}

\item{repl}{An optional index vector.  For each entry, specifies which
replicate the row belongs to, in the sense used in
\code{INLA::inla.spde.make.A}}

\item{n.repl}{The maximum replicate index, in the sense used in
\code{INLA::inla.spde.make.A()}.}

\item{weights}{Optional scaling weights to be applied row-wise to the
resulting matrix.}
}
\value{
A \code{Matrix::sparseMatrix} object.
}
\description{
Takes two Matrices and computes the row-wise Kronecker product.  Optionally
applies row-wise weights and/or applies an additional 0/1 row-wise Kronecker
matrix product.
}
\examples{
fm_row_kron(rbind(c(1, 1, 0), c(0, 1, 1)), rbind(c(1, 2), c(3, 4)))

}
\author{
Finn Lindgren \email{finn.lindgren@gmail.com}
}
