#' @title Example mesh data
#' @docType data
#' @description This is an example data set used for `fmesher` package examples.
#'
#' @usage
#' fmexample
#'
#' @format The data is a list containing these elements:
#'  \describe{
#'    \item{`loc`:}{ A `matrix` of points.}
#'    \item{`loc_sf`:}{ An `sfc` version of `loc`.}
#'    \item{`loc_sp`:}{ A `SpatialPoints` version of `loc`.}
#'    \item{`boundary_fm`:}{ A `fm_segm_list` of two `fm_segm` objects used in the mesh construction.}
#'    \item{`boundary_sf`:}{ An `sfc` list version of `boundary`.}
#'    \item{`boundary_sp`:}{ An `SpatialPolygons` list version of `boundary`.}
#'    \item{`mesh`:}{ An [fm_mesh_2d()] object.}
#'  }
#' @source
#' Generated by `data-raw/fmexample.R`.
#' @examples
#' if (require(ggplot2, quietly = TRUE)) {
#'   ggplot() +
#'     geom_sf(data = fm_as_sfc(fmexample$mesh)) +
#'     geom_sf(data = fmexample$boundary_sf[[1]], fill = "red", alpha = 0.5)
#' }
"fmexample"
