% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date-counters.R
\name{actual_actual_isda}
\alias{actual_actual_isda}
\title{The years between two dates using the Actual/Actual ISDA day basis
convention}
\usage{
actual_actual_isda(date1, date2)
}
\arguments{
\item{date1}{A date-time object}

\item{date2}{A date-time object}
}
\value{
a numeric value representing the number of years between
\code{date1} and \code{date2}.
}
\description{
This calculates the years between two dates using the Actual/Actual ISDA
day basis convention. This convention counts the number of calendars
between the start and end dates. The definition of a year is contingent on
whether the year is a leap year or not. The year fraction is calculated as:
\deqn{
  \frac{d_1}{{dy}_1} + \frac{d_2}{{dy}_2} + y_2 - y_1 - 1
}
}
\details{
where:

\itemize{
\item \eqn{d_1} is the remaining days in the first date's year including
both the start and end date
\item \eqn{d_2} is the number of days to the second date from the start
of that year
\item \eqn{{dy}_1} is 366 if the first date is in a leap year. Otherwise
it is 365
\item \eqn{{dy}_2} is 366 if the second date is in a leap year. Otherwise
it is 365
}

The order of \code{date1} and \code{date2} is not important. If \code{date1}
is less than \code{date2} then the result will be non-negative. Otherwise,
the result will be negative.
}
\keyword{internal}
