% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checks.r
\name{check_initial}
\alias{check_initial}
\title{Checks the initial values of the MCMC}
\usage{
check_initial(initial, nchains)
}
\arguments{
\item{initial}{Either a vector or matrix,.}

\item{nchains}{Integer scalar. Number of chains.}
}
\value{
A named matrix.
}
\description{
This function is for internal use only.
}
\details{
When \code{initial} is a vector, the values are recycled to form a matrix of
size \code{nchains * length(initial)}.
}
\examples{
init <- c(.4, .1)
check_initial(init, 1)
check_initial(init, 2)

init <- matrix(1:9, ncol=3)
check_initial(init, 3)

# check_initial(init, 2) # Returns an error

}
