% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flux_match.R
\name{flux_match}
\alias{flux_match}
\title{Matching continuously measured fluxes with measurement IDs and meta data}
\usage{
flux_match(
  raw_conc,
  field_record,
  f_datetime,
  start_col,
  end_col,
  measurement_length,
  fixed_length = deprecated(),
  time_diff = 0,
  startcrop = 0,
  ratio_threshold = deprecated(),
  f_conc = deprecated()
)
}
\arguments{
\item{raw_conc}{dataframe of CO2 concentration measured continuously.
Has to contain at least a datetime column in ymd_hms format and
a gas concentration column as double.}

\item{field_record}{dataframe recording which measurement happened when.
Has to contain at least a column containing the start of each measurement,
and any other column identifying the measurements.}

\item{f_datetime}{datetime column in raw_conc (\code{ymd_hms} format)}

\item{start_col}{start column in field_record (\code{ymd_hms} format)}

\item{end_col}{end column in field_record (\code{ymd_hms} format), if present
(see \code{measurement_length}).}

\item{measurement_length}{length of the measurements (in seconds)
from the start specified in the \code{field_record}. Use \code{measurement_length} if
all the measurements have the same length and no end column is present in
\code{field_record}.}

\item{fixed_length}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} no longer required.
\code{flux_match} will detect if \code{end_col} or \code{measurement_length} are provided.}

\item{time_diff}{time difference (in seconds) between the two datasets.
Will be added to the datetime column of the \code{raw_conc} dataset.
For situations where the time was not synchronized correctly.}

\item{startcrop}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{startcrop} is no longer
supported. Please use \code{start_cut} in \code{flux_fitting} instead.}

\item{ratio_threshold}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{ratio_threshold}
is no longer supported. Please use \code{ratio_threshold} in \code{flux_quality}
instead.}

\item{f_conc}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{f_conc} is no longer
required}
}
\value{
a dataframe with concentration measurements, corresponding datetime,
flux ID (\code{f_fluxid}), measurements start (\code{f_start}) and end (\code{f_end}).
}
\description{
Matching a dataframe of continuously measured
gas concentration data with measurement metadata from another dataframe.
Measurements are paired with their metadata based on datetime.
Extra variables in both dataframes are kept in the output.
}
\details{
If both \code{end_col} and \code{measurement_length} are provided, \code{end_col}
will be ignored. Measurements either all have the same length (provide
\code{measurement_length}), or the length varies and \code{end_col} has to be provided.
}
\examples{
data(co2_df_short, record_short)
flux_match(co2_df_short, record_short, datetime, start,
measurement_length = 180)
}
