% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flux_quality_exp.R
\name{flux_quality_exp}
\alias{flux_quality_exp}
\title{quality assessment for the slopes estimated by flux_fitting}
\usage{
flux_quality_exp(
  slopes_df,
  conc_col,
  f_fluxid,
  f_slope,
  f_time,
  f_fit,
  f_cut,
  f_b,
  force_discard,
  force_ok,
  rmse_threshold,
  cor_threshold,
  b_threshold
)
}
\arguments{
\item{slopes_df}{dataset containing slopes, fluxID,
and parameters of the exponential expression}

\item{conc_col}{column with gas concentration}

\item{f_fluxid}{column of ID for each measurement}

\item{f_slope}{column containing the slope of each flux
(as calculated by the flux_fitting function)}

\item{f_time}{column containing the time of each measurement in seconds}

\item{f_fit}{column containing the modeled data}

\item{f_cut}{column containing the cutting information}

\item{f_b}{column containing the b parameter of the exponential expression}

\item{force_discard}{vector of fluxIDs that should be discarded
by the user's decision}

\item{force_ok}{vector of fluxIDs for which the user wants to keep
the calculated slope despite a bad quality flag}

\item{rmse_threshold}{threshold for the RMSE of each flux above
which the fit is considered unsatisfactory}

\item{cor_threshold}{threshold for the correlation coefficient
of gas concentration with time below which the correlation
is considered non significant}

\item{b_threshold}{threshold for the b parameter. Defines a window
with its opposite inside which the fit is considered good enough.}
}
\value{
same dataframe with added flag and corrected slopes columns
}
\description{
indicates if fluxes should be discarded or replaced by 0
according to parameters set by user.
flux_quality_lm is for the model of the lm family.
flux_quality_exp is for the exponential model.
}
