% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/plot-funcs.R
\docType{methods}
\name{plot_flow,flow-method}
\alias{plot_flow}
\alias{plot_flow,flow-method}
\alias{plot_flow-method}
\title{plot_flow}
\usage{
\S4method{plot_flow}{flow}(x, detailed = TRUE, pdf = FALSE,
  pdffile = sprintf("\%s.pdf", x@name), type = c("1", "2"), ...)
}
\arguments{
\item{x}{Object of class \code{flow}}

\item{detailed}{include some details}

\item{pdf}{create a pdf instead of plotting interactively}

\item{pdffile}{output file name for the pdf file}

\item{type}{1 is original, and 2 is a elipse with less details}

\item{...}{experimental}
}
\description{
plot the flow object
}
\examples{
qobj = queue(type="lsf")
cmds = rep("sleep 5", 10)
jobj1 <- job(q_obj=qobj, cmd = cmds, submission_type = "scatter", name = "job1")
jobj2 <- job(q_obj=qobj, name = "job2", cmd = cmds, submission_type = "scatter",
             dependency_type = "serial", previous_job = "job1")
fobj <- flow(jobs = list(jobj1, jobj2))
plot_flow(fobj)

### Gather: many to one relationship
jobj1 <- job(q_obj=qobj, cmd = cmds, submission_type = "scatter", name = "job1")
jobj2 <- job(q_obj=qobj, name = "job2", cmd = cmds, submission_type = "scatter",
             dependency_type = "gather", previous_job = "job1")
fobj <- flow(jobs = list(jobj1, jobj2))
plot_flow(fobj)
### Burst: one to many relationship
jobj1 <- job(q_obj=qobj, cmd = cmds, submission_type = "serial", name = "job1")
jobj2 <- job(q_obj=qobj, name = "job2", cmd = cmds, submission_type = "scatter",
             dependency_type = "burst", previous_job = "job1")
fobj <- flow(jobs = list(jobj1, jobj2))
plot_flow(fobj)
}

