% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fc_draw.R
\name{fc_draw}
\alias{fc_draw}
\title{fc_draw}
\usage{
fc_draw(
  object,
  arrow_angle = 30,
  arrow_length = grid::unit(0.1, "inches"),
  arrow_ends = "last",
  arrow_type = "closed"
)
}
\arguments{
\item{object}{fc object that we want to draw.}

\item{arrow_angle}{The angle of the arrow head in degrees, as in `arrow`.}

\item{arrow_length}{A unit specifying the length of the arrow head (from tip to base), as in `arrow`.}

\item{arrow_ends}{One of "last", "first", or "both", indicating which ends of the line to draw arrow heads, as in `arrow`.}

\item{arrow_type}{One of "open" or "closed" indicating whether the arrow head should be a closed triangle, as in `arrow`.}
}
\value{
Invisibly returns the same object that has been given to the function, with the given arguments to draw the flowchart stored in the attributes.
}
\description{
This function allows to draw the flowchart from a fc object.
}
\examples{
safo |>
  as_fc(label = "Patients assessed for eligibility") |>
  fc_filter(!is.na(group), label = "Randomized", show_exc = TRUE) |>
  fc_split(group) |>
  fc_filter(itt == "Yes", label = "Included in ITT") |>
  fc_filter(pp == "Yes", label = "Included in PP") |>
  fc_draw()

}
