% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fc_stack.R
\name{fc_stack}
\alias{fc_stack}
\title{fc_stack}
\usage{
fc_stack(fcs, unite = TRUE)
}
\arguments{
\item{fcs}{list with all the flowcharts that we want to merge}

\item{unite}{logical value if the boxes have to be united or not}
}
\value{
List containing a list with the datasets belonging to each flowchart and the flowchart parameters combining all the flowcharts.
}
\description{
This function allows to combine vertically two different flowcharts.
}
\examples{
#Create first flowchart for patients
fc1 <- clinic_patient |>
  dplyr::filter(!is.na(group)) |>
  as_fc(label = "Patients included") |>
  fc_split(group)

#Create second flowchart for visits
fc2 <- clinic_visit |>
  dplyr::filter(!is.na(group)) |>
  as_fc(hide = TRUE) |>
  fc_split(group, label = rep("Number visits", 2), text_pattern = "{label}\\\\n #' {n}")

list(fc1, fc2) |>
  fc_stack() |>
  fc_draw()

}
