% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_pam.R
\name{get_pam}
\alias{get_pam}
\title{Get a presence-absence matrix}
\usage{
get_pam(data, by_Biome = TRUE, by_State = TRUE,
               by_vegetationType = FALSE, remove_empty_sites = TRUE,
               return_richness_summary = TRUE,
               return_spatial_richness = TRUE,
               return_plot = TRUE)
}
\arguments{
\item{data}{(data.frame) a data.frame imported with the
\code{\link{load_florabr}} function or generated by either
\code{\link{select_species}} or \code{\link{subset_species}} functions}

\item{by_Biome}{(logical) get occurrences by Biome. Default = TRUE}

\item{by_State}{(logical) get occurrences by State. Default = TRUE}

\item{by_vegetationType}{(logical) get occurrences by vegetation type.
Default = FALSE}

\item{remove_empty_sites}{(logical) remove empty sites (sites without any
species) from final presence-absence matrix. Default = TRUE}

\item{return_richness_summary}{(logical) return a data.frame with the number
of species in each site. Default = TRUE}

\item{return_spatial_richness}{(logical) return a SpatVector with the number
of species in each site. Default = TRUE}

\item{return_plot}{(logical) plot map with the number of species in each
site.
Only works if return_spatial_richness = TRUE. Default = TRUE}
}
\value{
If return_richness_summary and/or return_spatial_richness is set to
TRUE, return a list with:
\itemize{
\item PAM: the presence-absence matrix (PAM)
\item Richness_summary: a data.frame with the number of species in each site
\item Spatial_richness: a SpatVector with the number of species in each site
(only by State and Biome)
}

If return_richness_summary and return_spatial_richness is set to FALSE,
return a presence-absence matrix
}
\description{
Get a presence-absence matrix of species based on its distribution
(States, Biomes and vegetation types) according to Brazilian Flora 2020
}
\examples{
data("bf_data") #Load Brazilian Flora data
#Select endemic and native species of trees with occurrence only in Amazon
am_trees <- select_species(data = bf_data,
                          include_subspecies = FALSE,
                          include_variety = FALSE,
                          Kingdom = "Plantae",
                          Group = "All", Subgroup = "All",
                          Family = "All", Genus = "All",
                          LifeForm = "Tree", filter_LifeForm = "only",
                          Habitat = "All", filter_Habitat = "in",
                          Biome = "Amazon",
                          filter_Biome = "only",
                          State = "All", filter_State = "and",
                          VegetationType = "All",
                          filter_Vegetation = "in",
                          Endemism = "Endemic", Origin = "Native",
                          TaxonomicStatus = "Accepted",
                          NomenclaturalStatus = "All")
#Get presence-absence matrix
pam_am <- get_pam(data = am_trees, by_Biome = TRUE, by_State = TRUE,
                 by_vegetationType = FALSE, remove_empty_sites = TRUE,
                 return_richness_summary = TRUE,
                 return_spatial_richness = TRUE,
                 return_plot = TRUE)

}
\references{
Brazilian Flora 2020. Jardim Botânico do Rio de Janeiro. Available at:
http://floradobrasil.jbrj.gov.br/
}
