\name{volunteers}
\alias{volunteers}
\docType{data}
\title{
  Motivation of Australian Volunteers
}
\description{Part of an Australian survey on motivation of volunteers
  to work for non-profit organisations like Red Cross, State Emergency
  Service, Rural Fire Service, Surf Life Saving, Rotary, Parents and
  Citizens Associations, etc.. 
}
\usage{data(volunteers)}
\format{
  A data frame with 1415 observations on the following 21 variables: age
  and gender of respondents plus 19 binary motivation items (1 applies/
  0 does not apply).
  \describe{
    \item{\code{GENDER}}{Gender of respondent.}
    \item{\code{AGEG}}{Age group, a factor with categorized age of respondents.}
    \item{\code{meet.people}}{I can meet different types of people.}
    \item{\code{no.one.else}}{There is no-one else to do the work.}
    \item{\code{example}}{It sets a good example for others.}
    \item{\code{socialise}}{I can socialise with people who are like me.}
    \item{\code{help.others}}{It gives me the chance to help others.}
    \item{\code{give.back}}{I can give something back to society.}
    \item{\code{career}}{It will help my career prospects.}
    \item{\code{lonely}}{It makes me feel less lonely.}
    \item{\code{active}}{It keeps me active.}
    \item{\code{community}}{It will improve my community.}
    \item{\code{cause}}{I can support an important cause.}
    \item{\code{faith}}{I can put faith into action.}
    \item{\code{services}}{I want to maintain services that I may use one day.}
    \item{\code{children}}{My children are involved with the organisation.}
    \item{\code{good.job}}{I feel like I am doing a good job.}
    \item{\code{benefited}}{I know someone who has benefited from the organisation.}
    \item{\code{network}}{I can build a network of contacts.}
    \item{\code{recognition}}{I can gain recognition within the community.}
    \item{\code{mind.off}}{It takes my mind off other things.}
  }
}
\source{
The volunteering data was collected by the Institute for Innovation in
Business and Social Research, University of Wollongong (NSW, Australia),
using funding from Bushcare Wollongong and the Australian Research
Council under the ARC Linkage Grant scheme (LP0453682).
}
\references{
Melanie Randle and Sara Dolnicar. Not Just Any Volunteers: Segmenting the
Market to Attract the High-Contributors. Journal of Non-profit and
Public Sector Marketing, 21(3), 271-282, 2009.

Melanie Randle and Sara Dolnicar. Self-congruity and volunteering: A
multi-organisation comparison. European Journal of Marketing, 45(5),
739-758, 2011.

Melanie Randle, Friedrich Leisch, and Sara Dolnicar. Competition or
collaboration? The effect of non-profit brand image on volunteer
recruitment strategy. Journal of Brand Management, 20(8):689-704, 2013. 
}
\keyword{datasets}
