% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-bump-version.R, R/bump-version.R
\name{bump_version}
\alias{bump_version}
\alias{bump_version_impl}
\title{Bump package version}
\usage{
bump_version(which = "dev")
}
\arguments{
\item{which}{Component of the version number to update. Supported
values are \code{"dev"} (default), \code{"patch"}, \code{"minor"} and \code{"major"}.}
}
\value{
None
}
\description{
Calls the following functions:

\enumerate{
\item Verify that the current branch is the main branch.
\item \code{\link[=update_news]{update_news()}}
\item \code{\link[=update_version]{update_version()}}, using the \code{which} argument
\item Depending on the \code{which} argument:
\itemize{
\item If \code{"dev"}, \code{\link[=finalize_version]{finalize_version()}} with \code{push = FALSE}
\item Otherwise, \code{\link[=commit_version]{commit_version()}}.
}
}
}
\section{Bumped too soon?}{


Have you just run \code{bump_version()}, then realized
"oh shoot, I forgot to merge that PR"?
Fear not, run \code{\link[=unbump_version]{unbump_version()}}, merge that PR, run \code{bump_version()}.
}

\examples{
# Create mock package in a temporary directory.
# Set open to TRUE if you want to play in the mock package.
with_demo_project({
  # Use functions as if inside the newly created package project.
  # (Or go and actually run code inside the newly created package project!)
  # Add a new R file.
  usethis::use_r("cool-function", open = FALSE)
  # Pretend we added useful code inside it.
  # Track the new R file with Git.
  gert::git_add("R/cool-function.R")
  gert::git_commit("- Add cool function.")
  # Bump version with fledge.
  fledge::bump_version()
})
}
\seealso{
\code{\link[=unbump_version]{unbump_version()}}
}
