% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flatxml.r
\name{fxml_getAttributesAll}
\alias{fxml_getAttributesAll}
\title{Attributes of an XML element}
\usage{
fxml_getAttributesAll(xmlflat.df, elemid)
}
\arguments{
\item{xmlflat.df}{A flat XML dataframe created with \code{\link{fxml_importXMLFlat}}.}

\item{elemid}{The ID of the XML element. The ID is the value of the \code{elemid.} field in the flat XML dataframe.}
}
\value{
A named vector containing the attribute values of all attributes of the XML element with ID \code{elemid}. The names of the vector are the names of the attributes. Returns \code{NULL} if the element has no attributes at all.
}
\description{
Returns all attributes of an XML element and their respective values.
}
\examples{
# Load example file with population data from United Nations Statistics Division
# and create flat dataframe
example <- system.file("worldpopulation.xml", package="flatxml")
xml.dataframe <- fxml_importXMLFlat(example)

# Get all attribute of the XML element with ID 4 (xml.dataframe$elemid. ==  4)
fxml_getAttributesAll(xml.dataframe, 4)
}
\seealso{
\code{\link{fxml_hasAttributes}}, \code{\link{fxml_numAttributes}}, \code{\link{fxml_getAttribute}}
}
\author{
Joachim Zuckarelli \email{joachim@zuckarelli.de}
}
