% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivot_table.R
\name{replace_dec}
\alias{replace_dec}
\alias{replace_dec.pivot_table}
\title{Replace decimal separator}
\usage{
replace_dec(pt, sep)

\method{replace_dec}{pivot_table}(pt, sep = ".")
}
\arguments{
\item{pt}{A \code{pivot_table} object.}

\item{sep}{A character, new decimal separator to use.}
}
\value{
A \code{pivot_table} object.
}
\description{
A pivot table should only contain label rows and columns, and an array of
values, usually numeric data. Values, even though they are numbers, are
represented as text and sometimes include a decimal separator different from
the one needed; it can be replaced using this function.
}
\details{
To correctly carry out this operation, the number of rows and columns that
contain labels must be defined, and the table must only contain the pivot
table rows and columns.

The only decimal separators considered are "." and ",".
}
\examples{

pt <-
  pt_ex |>
  remove_top(1) |>
  define_labels(n_col = 2, n_row = 2) |>
  replace_dec()

}
\seealso{
\code{\link{pivot_table}}

Other pivot table transformation functions: 
\code{\link{extract_labels}()},
\code{\link{fill_labels}()},
\code{\link{fill_values}()},
\code{\link{remove_agg}()},
\code{\link{remove_bottom}()},
\code{\link{remove_cols}()},
\code{\link{remove_empty}()},
\code{\link{remove_k}()},
\code{\link{remove_left}()},
\code{\link{remove_right}()},
\code{\link{remove_rows}()},
\code{\link{remove_top}()},
\code{\link{unpivot}()}
}
\concept{pivot table transformation functions}
