% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_text_file.R
\name{read_text_file}
\alias{read_text_file}
\title{Import text file}
\usage{
read_text_file(file, sep = ";", encoding = "UTF-8")
}
\arguments{
\item{file}{A string, name of a text file.}

\item{sep}{Column separator character.}

\item{encoding}{A string, encoding to be assumed for input strings.}
}
\value{
A pivot_table object.
}
\description{
Reads a text file and creates a pivot_table object. The file is expected to
contain one or more pivot tables. Each line in the file corresponds to a row
in a table; within each row, columns are defined by a separator character.
The file name is included as part of the object attributes.
}
\details{
When multiple files are handled, the file name may contain information
associated with the pivot table, it could be the table page information. In
order not to lose this information, it is always stored in the pivot_table
object.
}
\examples{
file <- system.file("extdata", "csv/ine2871.csv", package = "flattabler")
pt <- read_text_file(file)

}
