% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ensembles}
\alias{ensembles}
\title{Ensemble forecasts of temperature and associated observation}
\format{
A named list with five entries, each containing a \code{data.table}
with 731 rows and a varying number of columns (depending on the number of
members).
\describe{
\item{date_run}{initial condition date (with format YYYY-MM-DD)}
\item{latitude}{latitude of the forecast location (in degrees)}
\item{longitude}{longitude of the forecast location (in degrees)}
\item{1 ... M}{member forecast (M members) in Kelvins}
\item{T}{the measured two-meter air temperature in Kelvins}
}
}
\source{
\url{https://apps.ecmwf.int/datasets/data/tigge/levtype=sfc/type=pf/}

\url{https://donneespubliques.meteofrance.fr/?fond=produit&id_produit=91&id_rubrique=32}
}
\usage{
ensembles
}
\description{
This is a data set containing the forecasts of five ensemble weather
prediction models for two-meter temperature from March, 2019 to March, 2021.
}
\details{
The five ensemble models are named CWAO (20 perturbed members, from ECCC),
DEMS (11 perturbed members, from NCMRWF), ECMF (50 members, from ECMWF),
EGRR (17 perturbed members, from UKMO) and RKSL (24 perturbed members, from
KMA).

The forecasts are the ones at the nearest grid point to Toulouse-Blagnac
station (France) in the TIGGE dataset. The observation is the two-meter
height temperature measured at this same station, at 06UTC. The forecast
initial time is 00UTC, with a 30 hour lead-time.
}
\keyword{datasets}
