% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals_flashlight.R
\name{residuals.flashlight}
\alias{residuals.flashlight}
\title{Residuals for flashlight}
\usage{
\method{residuals}{flashlight}(object, ...)
}
\arguments{
\item{object}{An object of class \code{flashlight}.}

\item{...}{Arguments used to update the flashlight before calculating the residuals.}
}
\value{
A numeric vector with residuals.
}
\description{
Residuals method for an object of class \code{flashlight}. Pass additional elements to update the flashlight before calculation of residuals.
}
\examples{
fit <- lm(Sepal.Length ~ ., data = iris)
(fl <- flashlight(model = fit, data = iris, y = "Sepal.Length", label = "ols"))
residuals(fl)[1:5]
residuals(fl, data = iris[1:5, ])
residuals(fl, data = iris[1:5, ], linkinv = exp)
resid(fl)[1:5]
}
