% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3-methods.R
\name{predictTrtEff}
\alias{predictTrtEff}
\title{Predict Treatment Effect}
\usage{
predictTrtEff(results, newdata = NULL)
}
\arguments{
\item{results}{An object of class rjMCMC containing the output from the \code{rjMCMC} procedure, including posterior samples and fitted splines.}

\item{newdata}{A data frame for which predicted values are to be computed If NA, the original fitted data is used.}
}
\value{
A matrix of predictive posterior samples for the treatment effect, where each row corresponds to a posterior sample
and each column corresponds to an observation in \code{newdata}.
}
\description{
This function predicts the treatment effect for new data based the Reversible Jump MCMC (rjMCMC) results.
}
\details{
The function:
\itemize{
\item Checks if the required columns in \code{results$candinter} are present in \code{newdata}.
\item Computes the fitted posterior treatment effect based on main treatment effects, spline interactions, and binary interactions.
\item Adds noise to the fitted posterior using the residual variance \code{results$sigma_sq} to generate predictive posterior samples.
}

Spline interactions are handled by interpolating the spline coefficients for the values in \code{newdata}.
}
\examples{
\donttest{
# Example dataset
data("simulated_data")

candsplinevars <- c("X_1")
candbinaryvars <- paste0("Z_", 1:5)
candinter <- c(candsplinevars, candbinaryvars)

mcmc_specs <- list(B = 2000, burnin = 1000, thin = 1, chains = 2, sigma_v = 0.1, bma = TRUE)
prior_params <- list(lambda_1 = 0.1, lambda_2 = 1, a_0 = 0.01, b_0 = 0.01,
                  degree = 3, k_max = 9, w = 1, sigma_B = sqrt(20))

results <- rjMCMC(simulated_data, candsplinevars, candbinaryvars, candinter,
                  mcmc_specs, prior_params)
newdata = data.frame(Z_1 = 1, Z_2 = 1, Z_3 = 1, Z_4 = 1, Z_5 = 1,
                   trt = 1, X_1 = seq(0,1,by=0.01))
predictTrtEff(results)
predictTrtEff(results,newdata)
}
}
