% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixest_multi.R
\name{coef.fixest_multi}
\alias{coef.fixest_multi}
\alias{coefficients.fixest_multi}
\title{Extracts the coefficients of fixest_multi objects}
\usage{
\method{coef}{fixest_multi}(object, keep, drop, order, ...)

\method{coefficients}{fixest_multi}(object, keep, drop, order, ...)
}
\arguments{
\item{object}{A \code{fixest_multi} object. Obtained from a multiple estimation.}

\item{keep}{Character vector. This element is used to display only a subset of variables. This should be a vector of regular expressions (see \code{\link[base]{regex}} help for more info). Each variable satisfying any of the regular expressions will be kept. This argument is applied post aliasing (see argument \code{dict}). Example: you have the variable \code{x1} to \code{x55} and want to display only \code{x1} to \code{x9}, then you could use \code{keep = "x[[:digit:]]$"}. If the first character is an exclamation mark, the effect is reversed (e.g. keep = "!Intercept" means: every variable that does not contain \dQuote{Intercept} is kept). See details.}

\item{drop}{Character vector. This element is used if some variables are not to be displayed. This should be a vector of regular expressions (see \code{\link[base]{regex}} help for more info). Each variable satisfying any of the regular expressions will be discarded. This argument is applied post aliasing (see argument \code{dict}). Example: you have the variable \code{x1} to \code{x55} and want to display only \code{x1} to \code{x9}, then you could use \code{drop = "x[[:digit:]]{2}"}. If the first character is an exclamation mark, the effect is reversed (e.g. drop = "!Intercept" means: every variable that does not contain \dQuote{Intercept} is dropped). See details.}

\item{order}{Character vector. This element is used if the user wants the variables to be ordered in a certain way. This should be a vector of regular expressions (see \code{\link[base]{regex}} help for more info). The variables satisfying the first regular expression will be placed first, then the order follows the sequence of regular expressions. This argument is applied post aliasing (see argument \code{dict}). Example: you have the following variables: \code{month1} to \code{month6}, then \code{x1} to \code{x5}, then \code{year1} to \code{year6}. If you want to display first the x's, then the years, then the months you could use: \code{order = c("x", "year")}. If the first character is an exclamation mark, the effect is reversed (e.g. order = "!Intercept" means: every variable that does not contain \dQuote{Intercept} goes first).  See details.}

\item{...}{Not currently used.}
}
\description{
Utility to extract the coefficients of multiple estimations and rearrange them into a matrix.
}
\examples{

base = iris
names(base) = c("y", "x1", "x2", "x3", "species")

# A multiple estimation
est = feols(y ~ x1 + csw0(x2, x3), base)

# Getting all the coefficients at once,
# each row is a model
coef(est)

# Example of keep/drop/order
coef(est, keep = "Int|x1", order = "x1")


# To change the order of the model, use fixest_multi
# extraction tools:
coef(est[rhs = .N:1])


}
