% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/index.R
\docType{package}
\name{fixest-package}
\alias{fixest}
\alias{fixest-package}
\title{Fast and User-Friendly Fixed-Effects Estimations}
\description{
The package \pkg{fixest} provides a family of functions to perform estimations with multiple fixed-effects. Standard-errors can be easily and intuitively clustered. It also includes tools to seamlessly export the results of various estimations.
\itemize{
\item To get started, look at the \href{https://cran.r-project.org/package=fixest/vignettes/fixest_walkthrough.html}{introduction}.
}
}
\details{
The main features are:
\itemize{
\item Estimation. The core functions are: \code{\link{feols}}, \code{\link{feglm}} and \code{\link{femlm}} to estimate, respectively, linear models, generalized linear models and maximum likelihood models with multiple fixed-effects. The function \code{\link{feNmlm}} allows the inclusion of non-linear in parameters right hand sides. Finally \code{\link[=feglm]{fepois}} and \code{\link[=femlm]{fenegbin}} are shorthands to estimate Poisson and Negative Binomial models.
\item Multiple estimations: You can perform multiple estimations at once with the \code{\link{stepwise}} functions. It's then very easy to manipulate multiple results with the associated methods. See an introduction in the dedicated vignette: \href{https://cran.r-project.org/package=fixest/vignettes/multiple_estimations.html}{Multiple estimations}
\item Easy and flexible clustering of standard-errors. By using the arguments \code{vcov} and \code{ssc} (see \code{\link{summary.fixest}}). To have a sense of how the standard errors are computed, see the vignette \href{https://lrberge.github.io/fixest/articles/standard_errors.html}{On standard-errors}.
\item Visualization and exportation of results. You can visualize the results of multiple estimations in R, or export them in Latex using the function \code{\link{etable}}. This vignette details how to customize the Latex tables: \href{https://lrberge.github.io/fixest/articles/exporting_tables.html}{Exporting estimation tables}.
\item Plot multiple results. You can plot the coefficients and confidence intervals of estimations easily with the function \code{\link{coefplot}}. This function also offers a specific layout for interactions.
}
}
\references{
Berge, Laurent, 2018, "Efficient estimation of maximum likelihood models with multiple fixed-effects: the R package FENmlm." CREA Discussion Papers, 13 (\href{https://github.com/lrberge/fixest/blob/master/_DOCS/FENmlm_paper.pdf}{}).
}
\seealso{
Useful links:
\itemize{
  \item \url{https://lrberge.github.io/fixest/}
  \item \url{https://github.com/lrberge/fixest}
  \item Report bugs at \url{https://github.com/lrberge/fixest/issues}
}

}
\author{
\strong{Maintainer}: Laurent Berge \email{laurent.berge@u-bordeaux.fr}

Other contributors:
\itemize{
  \item Sebastian Krantz [contributor]
  \item Grant McDermott \email{grantmcd@uoregon.edu} (\href{https://orcid.org/0000-0001-7883-8573}{ORCID}) [contributor]
}

}
\keyword{internal}
