% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixest_env.R
\name{stepwise}
\alias{stepwise}
\alias{sw}
\alias{csw}
\alias{sw0}
\alias{csw0}
\title{Stepwise estimation tools}
\usage{
sw(...)

csw(...)

sw0(...)

csw0(...)
}
\arguments{
\item{...}{Represents formula variables to be added in a stepwise fashion to an estimation.}
}
\description{
Functions to perform stepwise estimations.
}
\details{
To include multiple independent variables, you need to use the stepwise functions. There are 4 stepwise functions: sw, sw0, csw, csw0. Let's explain that.

Assume you have the following formula: \code{fml = y ~ x1 + sw(x2, x3)}. The stepwise function \code{sw} will estimate the following two models: \code{y ~ x1 + x2} and \code{y ~ x1 + x3}. That is, each element in \code{sw()} is sequentially, and separately, added to the formula. Would have you used \code{sw0} in lieu of \code{sw}, then the model \code{y ~ x1} would also have been estimated. The \code{0} in the name implies that the model without any stepwise element will also be estimated.

Finally, the prefix \code{c} means cumulative: each stepwise element is added to the next. That is, \code{fml = y ~ x1 + csw(x2, x3)} would lead to the following models \code{y ~ x1 + x2} and \code{y ~ x1 + x2 + x3}. The \code{0} has the same meaning and would also lead to the model without the stepwise elements to be estimated: in other words, \code{fml = y ~ x1 + csw0(x2, x3)} leads to the following three models: \code{y ~ x1}, \code{y ~ x1 + x2} and \code{y ~ x1 + x2 + x3}.
}
\examples{

base = iris
names(base) = c("y", "x1", "x2", "x3", "species")

# Regular stepwise
feols(y ~ sw(x1, x2, x3), base)

# Cumulative stepwise
feols(y ~ csw(x1, x2, x3), base)

# Using the 0
feols(y ~ x1 + x2 + sw0(x3), base)

}
