% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.R
\name{fixer_convert}
\alias{fixer_convert}
\title{Convert currencies}
\usage{
fixer_convert(from, to, amount = 1, date = NULL)
}
\arguments{
\item{from}{Symbol of currency to convert from.}

\item{to}{Symbol of currency to convert to.}

\item{amount}{The numeric value of the \code{from} currency to convert.
Defaults to 1.}

\item{date}{Optional variable. A date in YYYY-MM-DD format, or any value
that can be coerced to YYYY-MM-DD format with \code{as.Date()}.
Defaults to \code{NULL}, which returns the latest conversion data.}
}
\value{
A list containing the value of the conversion and the exchange rate.
}
\description{
Currency conversion is only available on paid plans.
}
\examples{
\dontrun{

x <- fixer_convert(from = "GBP", to = "JPY", amount = 25)

}
}
