% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.R
\name{ggspotratecurveplot}
\alias{ggspotratecurveplot}
\title{Fancy ggplot for SpotRateCurve object}
\usage{
ggspotratecurveplot(
  curve,
  title = NULL,
  subtitle = NULL,
  caption = NULL,
  curve.name = NULL,
  curve.interpolation = FALSE,
  curve.x.axis = c("dates", "terms"),
  ...
)
}
\arguments{
\item{curve}{SpotRateCurve object}

\item{title}{plot title}

\item{subtitle}{plot subtitle}

\item{caption}{plot caption}

\item{curve.name}{Curve's name, if not provided curve's refdate is used.}

\item{curve.interpolation}{logical indicating to use daily interpolation
instead of curve points. Defaults to \code{FALSE}.}

\item{curve.x.axis}{x axis can be presented with a numeric scale representing
business days (\code{terms}) or dates (\code{dates}). Defaults to \code{dates}.}

\item{...}{additional arguments (not used)}
}
\description{
Fancy ggplot for SpotRateCurve object with custom axis, title
}
\examples{
\dontrun{
terms <- c(1, 11, 26, 27, 28)
rates <- c(0.0719, 0.056, 0.0674, 0.0687, 0.07)
curve <- spotratecurve(rates, terms, "discrete", "actual/365", "actual")
ggspotratecurveplot(curve)
}
}
