% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spotratecurve-class.R
\name{maturities}
\alias{maturities}
\title{Get SpotRateCurve terms as Date objects}
\usage{
maturities(x)
}
\arguments{
\item{x}{a SpotRateCurve object.}
}
\value{
A vector of \code{Date} objects that represent the curve's \code{terms} and using
curve's \code{refdate} as a starting point.
}
\description{
Compute the SpotRateCurve terms as Date objects, according to the curve's
reference date.
}
\examples{
terms <- c(1, 11, 26, 27, 28)
rates <- c(0.0719, 0.056, 0.0674, 0.0687, 0.07)
curve <- spotratecurve(rates, terms, "discrete", "actual/365", "actual")
maturities(curve)
}
