% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_meredith.R
\docType{data}
\name{ratings}
\alias{ratings}
\title{An Inconvenient Sequel}
\format{Because of R package size restrictions, only a preview of the
first 10 rows of this dataset is included; to obtain the entire dataset
(80,053 rows) see Examples below. The preview is a data frame with 10 rows 
representing movie ratings and 27 variables:
\describe{
  \item{timestamp}{The date at which the rating was recorded.}
  \item{respondents}{The number of respondents in a category associated with a given timestamp.}
  \item{category}{The subgroups of respondents differentiated by demographics like gender, age, and nationality.}
  \item{link}{The website associated with a given category's responses.}
  \item{average}{The average rating reported by a given category.}
  \item{mean}{The mean rating reported by a given category.}
  \item{median}{The median rating reported by a given category.}
  \item{votes_1}{The count of votes denoting a rating of one that respondents gave.}
  \item{votes_2}{The count of votes denoting a rating of two that respondents gave.}
  \item{votes_3}{The count of votes denoting a rating of three that respondents gave.}
  \item{votes_4}{The count of votes denoting a rating of four that respondents gave.}
  \item{votes_5}{The count of votes denoting a rating of five that respondents gave.}
  \item{votes_6}{The count of votes denoting a rating of six that respondents gave.}
  \item{votes_7}{The count of votes denoting a rating of seven that respondents gave.}
  \item{votes_8}{The count of votes denoting a rating of eight that respondents gave.}
  \item{votes_9}{The count of votes denoting a rating of nine that respondents gave.}
  \item{votes_10}{The count of votes denoting a rating of ten that respondents gave.}
  \item{pct_1}{The percentage of votes denoting a rating of one that respondents gave.}
  \item{pct_2}{The percentage of votes denoting a rating of two that respondents gave.}
  \item{pct_3}{The percentage of votes denoting a rating of three that respondents gave.}
  \item{pct_4}{The percentage of votes denoting a rating of four that respondents gave.}
  \item{pct_5}{The percentage of votes denoting a rating of five that respondents gave.}
  \item{pct_6}{The percentage of votes denoting a rating of six that respondents gave.}
  \item{pct_7}{The percentage of votes denoting a rating of seven that respondents gave.}
  \item{pct_8}{The percentage of votes denoting a rating of eight that respondents gave.}
  \item{pct_9}{The percentage of votes denoting a rating of nine that respondents gave.}
  \item{pct_10}{The percentage of votes denoting a rating of ten that respondents gave.}
}}
\source{
IMBD \url{https://www.imdb.com/title/tt6322922/ratings} and
see \url{https://github.com/fivethirtyeight/data/tree/master/inconvenient-sequel}
}
\usage{
ratings
}
\description{
The raw data behind the story
"Al Gore's New Movie Exposes The Big Flaw In Online Movie Ratings"
\url{https://fivethirtyeight.com/features/al-gores-new-movie-exposes-the-big-flaw-in-online-movie-ratings/}.
}
\examples{
# To obtain the entire dataset, run the following code:
library(readr)
library(dplyr)
ratings <- 
  "https://github.com/fivethirtyeight/data/raw/master/inconvenient-sequel/ratings.csv" \%>\%
  read_csv() \%>\%
  mutate(category = as.factor(category)) \%>\% 
  rename(
    votes_1 = `1_votes`, votes_2 = `2_votes`, votes_3 = `3_votes`, 
    votes_4 = `4_votes`, votes_5 = `5_votes`, votes_6 = `6_votes`,
    votes_7 = `7_votes`, votes_8 = `8_votes`, votes_9 = `9_votes`,
    votes_10 = `10_votes`,
    pct_1 = `1_pct`, pct_2 = `2_pct`, pct_3 = `3_pct`, pct_4 = `4_pct`,
    pct_5 = `5_pct`, pct_6 = `6_pct`, pct_7 = `7_pct`, pct_8 = `8_pct`,
    pct_9 = `9_pct`, pct_10 = `10_pct`
  )

# To convert data frame to tidy data (long) format, run:
library(dplyr)
library(tidyr)
library(stringr)
ratings_tidy <- ratings \%>\%
  gather(votes, count, -c(timestamp, respondents, category, link, average, mean, median)) \%>\%
  arrange(timestamp)
}
\keyword{datasets}
