% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_maggie.R
\docType{data}
\name{nba_carmelo}
\alias{nba_carmelo}
\title{The Complete History Of The NBA
2017-18 NBA Predictions}
\format{Because of R package size restrictions, only a preview of the
first 10 rows of this dataset is included; to obtain the entire dataset
(1871 to 2017 games) see Examples below. A data frame with 10 rows representing games and 20 variables:
\describe{
 \item{date}{Date}
 \item{season}{Season year, 1947-2018}
 \item{neutral}{TRUE if the game was played on neutral territory, FALSE if not}
 \item{playoff}{TRUE if the game was a playoff game, FALSE if not}
 \item{team1}{The name of one participating team}
 \item{team2}{The name of the other participating team}
 \item{elo1_pre}{Team 1's Elo rating before the game}
 \item{elo2_pre}{Team 2's Elo rating before the game}
 \item{elo_prob1}{Team 1's probability of winning based on Elo rating}
 \item{elo_prob2}{Team 2's probability of winning based on Elo rating}
 \item{elo1_post}{Team 1's Elo rating after the game}
 \item{elo2_post}{Team 2's Elo rating after the game}
 \item{carmelo1_pre}{Team 1's CARMELO rating before the game}
 \item{carmelo2_pre}{Team 2's CARMELO rating before the game}
 \item{carmelo1_post}{Team 1's CARMELO rating after the game}
 \item{carmelo2_post}{Team 2's CARMELO rating after the game}
 \item{carmelo_prob1}{Team 1's probability winning based on CARMELO rating}
 \item{carmelo_prob2}{Team 2's probability of winning based on CARMELO rating}
 \item{score1}{Points scored by Team 1}
 \item{score2}{Points scored by Team 2}
}}
\source{
See \url{https://projects.fivethirtyeight.com/nba-model/nba_elo.csv}
}
\usage{
nba_carmelo
}
\description{
The raw data behind the story
"The Complete History Of The NBA"
\url{https://projects.fivethirtyeight.com/complete-history-of-the-nba/}
and our "2017-18 NBA Predictions"
\url{https://projects.fivethirtyeight.com/2018-nba-predictions/}
}
\examples{
# To obtain the entire dataset, run the following code:
library(dplyr)
library(tidyr)
library(readr)
library(janitor)
nba_carmelo <- read_csv("https://projects.fivethirtyeight.com/nba-model/nba_elo.csv") \%>\%
  clean_names() \%>\%
  mutate(
    team1 = as.factor(team1),
    team2 = as.factor(team2),
    playoff = ifelse(playoff == "t", TRUE, FALSE),
    playoff = ifelse(is.na(playoff), FALSE, TRUE),
    neutral = ifelse(neutral == 1, TRUE, FALSE)
  )
}
\keyword{datasets}
