% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.psData.R
\name{==.psData}
\alias{==.psData}
\title{S3 method for objects of class \code{psData}}
\usage{
\method{==}{psData}(lhs, rhs)
}
\arguments{
\item{lhs}{an object of class \code{psData}.}

\item{rhs}{an object of class \code{psData}.}
}
\value{
TRUE if the two objects are equal
}
\description{
Tests to see if two objects of class \code{psData} are equal. That is
their \code{type} is the same, and the data contained in \code{data} is the
same. See \code{\link{readData}} for a description of the \code{psData} class.
}
\examples{
p = readData(system.file("extdata", "p.xlsx", package = "fitPS"))
p1 = makePSData(n = 0:2, count = c(98, 1, 1), type = "P")
p2 = makePSData(n = 0:2, count = c(97, 2, 1), type = "P")
p == p1 ## TRUE
p == p2 ## FALSE
p1 == p2 ## FALSE
}
