% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CorrBin.R
\name{dCorrBin}
\alias{dCorrBin}
\title{Correlated  Binomial Distribution}
\usage{
dCorrBin(x,n,p,cov)
}
\arguments{
\item{x}{vector of binomial random variables}

\item{n}{single value for no of binomial trials}

\item{p}{single value for probability of success}

\item{cov}{single value for covariance}
}
\value{
The output of \code{dCorrBin} gives a list format consisting

\code{pdf}           probability function values in vector form

\code{mean}          mean of Correlated  Binomial Distribution

\code{var}           variance of Correlated  Binomial Distribution

\code{corr}          correlation of Correlated Binomial Distribution

\code{mincorr}       minimum correlation value possible

\code{maxcorr}       maximum correlation value possible
}
\description{
These functions provide the ability for generating probability function values and
cumulative probability function values for the Correlated  Binomial Distribution.
}
\details{
The probability function and cumulative function can be constructed and are denoted below

The cumulative probability function is the summation of probability function values

\deqn{P_{CorrBin}(x) = {n \choose x}(p^x)(1-p)^{n-x}(1+(\frac{cov}{2p^2(1-p)^2})((x-np)^2+x(2p-1)-np^2)) }
\deqn{x = 0,1,2,3,...n}
\deqn{n = 1,2,3,...}
\deqn{0 < p < 1}
\deqn{-\infty < cov < +\infty }

The Correlation is in between
\deqn{\frac{-2}{n(n-1)} min(\frac{p}{1-p},\frac{1-p}{p}) \le correlation \le \frac{2p(1-p)}{(n-1)p(1-p)+0.25-fo} }
where \eqn{fo=min [(x-(n-1)p-0.5)^2] }

The mean and the variance are denoted as
\deqn{E_{CorrBin}[x]= np}
\deqn{Var_{CorrBin}[x]= n(p(1-p)+(n-1)cov)}
\deqn{Corr_{CorrBin}[x]=\frac{cov}{p(1-p)}}

\strong{NOTE} : If input parameters are not in given domain conditions
necessary error messages will be provided to go further
}
\examples{
#plotting the random variables and probability values
col<-rainbow(5)
a<-c(0.58,0.59,0.6,0.61,0.62)
b<-c(0.022,0.023,0.024,0.025,0.026)
plot(0,0,main="Correlated binomial probability function graph",xlab="Binomial random variable",
ylab="Probability function values",xlim = c(0,10),ylim = c(0,0.5))
for (i in 1:5)
{
lines(0:10,dCorrBin(0:10,10,a[i],b[i])$pdf,col = col[i],lwd=2.85)
points(0:10,dCorrBin(0:10,10,a[i],b[i])$pdf,col = col[i],pch=16)
}
dCorrBin(0:10,10,0.58,0.022)$pdf      #extracting the pdf values
dCorrBin(0:10,10,0.58,0.022)$mean     #extracting the mean
dCorrBin(0:10,10,0.58,0.022)$var      #extracting the variance
dCorrBin(0:10,10,0.58,0.022)$corr     #extracting the correlation
dCorrBin(0:10,10,0.58,0.022)$mincorr  #extracting the minimum correlation value
dCorrBin(0:10,10,0.58,0.022)$maxcorr  #extracting the maximum correlation value

#plotting the random variables and cumulative probability values
col<-rainbow(5)
a<-c(0.58,0.59,0.6,0.61,0.62)
b<-c(0.022,0.023,0.024,0.025,0.026)
plot(0,0,main="Correlated binomial probability function graph",xlab="Binomial random variable",
ylab="Probability function values",xlim = c(0,10),ylim = c(0,1))
for (i in 1:5)
{
lines(0:10,pCorrBin(0:10,10,a[i],b[i]),col = col[i],lwd=2.85)
points(0:10,pCorrBin(0:10,10,a[i],b[i]),col = col[i],pch=16)
}
pCorrBin(0:10,10,0.58,0.022)      #acquiring the cumulative probability values

}
\references{
Johnson, N. L., Kemp, A. W., & Kotz, S. (2005). Univariate discrete distributions (Vol. 444).
Hoboken, NJ: Wiley-Interscience.

L. L. Kupper, J.K.H., 1978. The Use of a Correlated Binomial Model for the Analysis of Certain Toxicological
Experiments. Biometrics, 34(1), pp.69-76.

Paul, S.R., 1985. A three-parameter generalization of the binomial distribution. Communications in Statistics
- Theory and Methods, 14(6), pp.1497-1506.

Available at: \url{http://www.tandfonline.com/doi/abs/10.1080/03610928508828990} .

Jorge G. Morel and Nagaraj K. Neerchal. Overdispersion Models in SAS. SAS Institute, 2012.
}
\seealso{
\code{\link[BinaryEPPM]{CBprob}}
}
