\name{design.distance}
\alias{design.distance}
\alias{design.distance.default}

\title{Design Distance}

\description{
The design distance is the mahalanobis distance of each point in the deisgn matrix.
}

\usage{
design.distance(object, \dots)
\method{design.distance}{default}(object, \dots)
}

\arguments{
  \item{object}{a fitted model object containing a model frame component.}
  \item{\dots}{additional arguments are passed to the dispatched method.}
}

\value{
a numeric vactor containing the design distances.
}

\examples{
## Example from lm:
ctl <- c(4.17,5.58,5.18,6.11,4.50,4.61,5.17,4.53,5.33,5.14)
trt <- c(4.81,4.17,4.41,3.59,5.87,3.83,6.03,4.89,4.32,4.69)
group <- gl(2,10,20, labels=c("Ctl","Trt"))
weight <- c(ctl, trt)
lm.D9 <- lm(weight ~ group)

design.distance(lm.D9)
}

\keyword{regression}
\keyword{methods}
