% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fipe.R
\name{fipe_vehicle}
\alias{fipe_vehicle}
\title{Access to the Fipe Database}
\usage{
fipe_vehicle(model, make = NULL, year = NULL, date = Sys.Date(),
  progress = FALSE, parallel = FALSE)
}
\arguments{
\item{model}{a character vector. Vehicle model name.}

\item{make}{a character vector. If NULL, search all models in all makes,
otherwise only those indicated.}

\item{year}{a numeric vector. Year of manufacture of the vehicle. If 0
returns vehicles 0 km.}

\item{date}{a date vector. Reference date for the vehicle price.}

\item{progress}{a logical, if TRUE print a progress bar.}

\item{parallel}{a logical, if TRUE apply function in parallel.}
}
\value{
A data frame/tibble including model, make, year, date and price.
}
\description{
Access to the Fipe Database
}
\details{
The Fipe Database shows the average purchase price of vehicles in
  the Brazilian national market. The prices are effectively used in purchase
  negotiations according to region, vehicle’s conservation, color,
  accessories or any other factor that might influence the demand and supply
  for a specific vehicle. The year of the vehicle refers to the model year,
  and the vehicles are not considered for professional or special use. The
  values are expressed in R$ (reais) for each month/year of reference.
}
\examples{
\donttest{
fipe_vehicle(
  model = "etios platinum", make = "toyota",
  date = "2019-08-01", year = c(0, 2019, 2018)
)
}

}
\seealso{
Official Website \url{https://veiculos.fipe.org.br}.
}
