% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finnishgrid.R
\name{up_regulation_price_balancing_energy_market}
\alias{up_regulation_price_balancing_energy_market}
\title{Up-regulating price in the Balancing energy market}
\usage{
up_regulation_price_balancing_energy_market(
  start_time = NA,
  end_time = NA,
  user_key = NA
)
}
\arguments{
\item{start_time}{Start time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{end_time}{End time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{user_key}{Character array holding API-key.
Free from https://data.fingrid.fi/open-data-forms/registration/}
}
\value{
A data frame object that contains up-regulating price in Finland,
which is the price of the most expensive up-regulating bid used in the
Balancing energy market during the hour in question; however, it is at
least the day ahead market price for the price area Finland.
Up-regulating price for each hour is published hourly with one hour
delay, eg. information from hour 07-08 is published at 9 o'clock.
}
\description{
Check https://data.fingrid.fi/en/dataset/up-regulating-price-in-the-balancing-energy-market
}
\examples{
\dontrun{
library(finnishgrid)
start = "2021-01-01T00:00:00+0200"  # UTC+2 offset, Helsinki time
end = "2021-01-10T00:00:00+0200"    # UTC+2 offset, Helsinki time
key = "MY_SUPER_SECRET"
df <- up_regulation_price_balancing_energy_market(
    start_time = start,
    end_time = end,
    user_key = key)
summary(df)
}
}
