% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fingertips_data.R
\name{fingertips_data}
\alias{fingertips_data}
\title{Fingertips data}
\usage{
fingertips_data(IndicatorID = NULL, AreaCode = NULL, DomainID = NULL,
  ProfileID = NULL, AreaTypeID = 102, ParentAreaTypeID = NULL,
  inequalities = FALSE)
}
\arguments{
\item{IndicatorID}{Numeric vector, id of the indicator of interest}

\item{AreaCode}{Character vector, ONS area code of area of interest}

\item{DomainID}{Numeric vector, id of domains of interest}

\item{ProfileID}{Numeric vector, id of profiles of interest}

\item{AreaTypeID}{Numeric vector, the Fingertips ID for the area type;
default is NULL}

\item{ParentAreaTypeID}{Numeric vector, the comparator area type for the data
extracted; if NULL the function will use the first record for the specified `AreaTypeID` from the area_types() function}

\item{inequalities}{TRUE or FALSE, determines whether the final table includes inequalities data where it exists. Default
to FALSE}
}
\value{
A data frame of data extracted from the Fingertips API
}
\description{
Outputs a data frame of data from
\href{http://fingertips.phe.org.uk/}{Fingertips}
}
\examples{
\dontrun{
# Returns data for the two selected domains at county and unitary authority geography
doms <- c(1000049,1938132983)
fingdata <- fingertips_data(DomainID = doms)#'

# Returns data at local authority district geography for the indicator with the id 22401
fingdata <- fingertips_data(22401, AreaTypeID = 101)}
}
