% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hr_plot.R
\name{hr_plot}
\alias{hr_plot}
\title{Produce a hazard ratio table and plot}
\usage{
hr_plot(.data, dependent, explanatory, factorlist = NULL,
  coxfit = NULL, remove_ref = FALSE, breaks = NULL,
  column_space = c(-0.5, 0, 0.5), dependent_label = "Survival",
  prefix = "", suffix = ": HR (95\% CI, p-value)",
  table_text_size = 5, title_text_size = 18, plot_opts = NULL,
  table_opts = NULL, ...)
}
\arguments{
\item{.data}{Dataframe.}

\item{dependent}{Character vector of length 1:  name of survival object in form \code{Surv(time, status)}.}

\item{explanatory}{Character vector of any length: name(s) of explanatory variables.}

\item{factorlist}{Option to provide output directly from \code{\link{summary_factorlist}()}.}

\item{coxfit}{Option to provide output directly from \code{coxphmulti()}.}

\item{remove_ref}{Logical. Remove reference level for factors.}

\item{breaks}{Manually specify x-axis breaks in format \code{c(0.1, 1, 10)}.}

\item{column_space}{Adjust table column spacing.}

\item{dependent_label}{Main label for plot.}

\item{prefix}{Plots are titled by default with the dependent variable. This adds text before that label.}

\item{suffix}{Plots are titled with the dependent variable. This adds text after that label.}

\item{table_text_size}{Alter font size of table text.}

\item{title_text_size}{Alter font size of title text.}

\item{plot_opts}{A list of arguments to be appended to the ggplot call by "+".}

\item{table_opts}{A list of arguments to be appended to the ggplot table call by "+".}

\item{...}{Other parameters passed to \code{fit2df()}.}
}
\value{
Returns a table and plot produced in \code{ggplot2}.
}
\description{
Produce hazard ratio table and plot from a Cox Proportional Hazards analysis, \code{survival::coxph()}.
}
\examples{
# HR plot
library(finalfit)
library(dplyr)
library(ggplot2)

data(colon_s)
explanatory = c("age.factor", "sex.factor", "obstruct.factor", "perfor.factor")
dependent = "Surv(time, status)"
colon_s \%>\%
  hr_plot(dependent, explanatory, dependent_label = "Survival")

colon_s \%>\%
  hr_plot(dependent, explanatory, dependent_label = "Survival",
    table_text_size=4, title_text_size=14,
    plot_opts=list(xlab("HR, 95\% CI"), theme(axis.title = element_text(size=12))))

}
\seealso{
Other finalfit plot functions: \code{\link{coefficient_plot}},
  \code{\link{ff_plot}}, \code{\link{or_plot}},
  \code{\link{surv_plot}}
}
\concept{finalfit plot functions}
