% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/files.R
\name{merge_tables_on_disk}
\alias{merge_tables_on_disk}
\title{Merge tables on disk.}
\usage{
merge_tables_on_disk(files, delim, out_name, header = TRUE, ...)
}
\arguments{
\item{files}{The paths to the files to merge.}

\item{delim}{Delimeter used to separate values.}

\item{out_name}{The path to the output file containing the merged tables.}

\item{header}{Do the tables to be merged have headers?}

\item{...}{Additional arguments passed to \link[readr:read_delim]{readr::read_delim}.}
}
\description{
Merge tables saved on disk as delimited files. The merging is done lengthways
so they need to have the same number of columns and the same column names (if
they have column names).
}
\examples{
setwd(tempdir())
dir.create("MergeTablesOnDisk_test")
setwd("MergeTablesOnDisk_test")
tab1 <- tibble::tibble(x = 1, y = 2)
tab2 <- tibble::tibble(x = 1, y = 29)
mapply(readr::write_csv, list(tab1, tab2), paste0(c("tab1", "tab2"), ".csv"))
merge_tables_on_disk(c("tab1.csv", "tab2.csv"), ",", "merged.csv")
readr::read_csv("merged.csv")
setwd("..")
dir.remove("MergeTablesOnDisk_test")
}
