% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fileply.R
\name{fileply}
\alias{fileply}
\title{fileply}
\usage{
fileply(file, groupby, fun = identity, collect = "none",
  temploc = getwd(), nbins = 10, chunk = 50000, spill = 1e+06,
  cores = 1, buffer = 1e+09, keepddf = FALSE, ...)
}
\arguments{
\item{file}{(string) path to input delimited file}

\item{groupby}{(character vector) Columns names to used to split the data(if 
missing, \code{fun} is applied on each chunk)}

\item{fun}{(object of class \emph{function}) function to apply on each subset
after the split}

\item{collect}{(string) Collect the result as \code{list} or \code{dataframe}
or \code{none}. \code{none} keeps the resulting ddo on disk.}

\item{temploc}{(string) Path where intermediary files are kept}

\item{nbins}{(positive integer) Number of directories into which the 
distributed dataframe (ddf) or distributed data object (ddo) is distributed}

\item{chunk}{(positive integer) Number of rows of the file to be read at a 
time}

\item{spill}{(positive integer) Maximum number of rows of any subset 
resulting from split}

\item{cores}{(positive integer) Number of cores to be used in parallel}

\item{buffer}{(positive integer) Size of batches of key-value pairs to be 
passed to the map OR Size of the batches of key-value pairs to flush to 
intermediate storage from the map output OR Size of the batches of 
key-value pairs to send to the reduce}

\item{keepddf}{(flag) whether to save the distributed dataframe (on the disk)}

\item{...}{Arguments to be passed to \code{data.table} function asis.}
}
\value{
list or a dataframe or a TRUE(when collect is 'none').
}
\description{
performs chunk processing or split-apply-combine on the data
  in a delimited file (example: CSV).
}
\details{
\itemize{\item \strong{Reading Stage:} The delimited file (example:
  CSV) is read in smaller chunks to create a distributed dataframe or 
  \strong{ddf} on disk. The number of lines read at once is specified by 
  \code{chunk} argument and \code{nbins} specify the number of 
  sub-directories the data is distributed. The \code{...} are additional 
  inputs to \code{data.table} function for reading the delimited file. \item 
  \strong{Split and Apply Stage:} The variables in \code{groupby} are used to
  split the data and load only the subset(possibly many if multiple cores are
  in action) into the memory. If \code{groupby}  is missing, chunkwise 
  processing is performed on each subset of the distributed dataframe. A user
  defined \code{fun} is applied and results are written to a distributed 
  object(list or a KV pairs) on disk. \item \strong{Combine Stage:} The 
  distributed data object(\strong{ddo}) is read into memory depending on 
  \code{collect} argument. The default is set to 'none' which would not the 
  data back into memory.}
  
  \strong{Memory usage: } While processing heavy files(many times the RAM 
  size), each core might hold a maximum of 800 MB to 1GB of memory overhead 
  without accounting for the memory used by the user defind function. Memory 
  usage depending on size of the subset, how many times it is copied by the 
  user function, how frequently is \code{gc} called. Using appropriate number
  of cores keeps memory utilization in check. Setting a smaller \code{buffer}
  value keeps memory usage low, see \code{\link[datadr]{localDiskControl}}, 
  but makes the execution slower.
}
\examples{
# split-apply-combine
write.table(mtcars, "mtcars.csv", row.names = FALSE, sep = ",")
temp <- fileply(file     = "mtcars.csv"
             , groupby = c("carb", "gear")
             , fun     = identity
             , collect = "list"
             , sep     =  ","
             , header  = TRUE
             )
temp
unlink("mtcars.csv")

# chunkwise processing
write.table(mtcars, "mtcars.csv", row.names = FALSE, sep = ",")
temp <- fileply(file     = "mtcars.csv"
             , chunk   = 10
             , fun     = function(x){list(nrow(x))}
             , collect = "dataframe"
             , sep     =  ","
             , header  = TRUE
             )
temp
unlink("mtcars.csv")

# example for collect='none'
write.table(mtcars, "mtcars.csv", row.names = FALSE, sep = ",")
outdir <- utils::capture.output(temp <- fileply(file      = "mtcars.csv"
                                                , groupby = c("carb", "gear")
                                                , fun     = identity
                                                , sep     =  ","
                                                , header  = TRUE
                                                )
                                , file = NULL
                                , type = "message"
                                )
outdir <- gsub("Output Directory: ", "", outdir[5])
diskKV <- datadr::ddo(datadr::localDiskConn(outdir))
diskKV
diskKV[[1]]
unlink(outdir, recursive = TRUE)
unlink("mtcars.csv")

}

