% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R2.R
\name{r2}
\alias{r2}
\alias{r2.pibblefit}
\alias{r2.bassetfit}
\title{Generic Method to Calculate R2 for Fitted Model}
\usage{
r2(m, ...)

\method{r2}{pibblefit}(m, covariates = NULL, ...)

\method{r2}{bassetfit}(m, covariates = NULL, components = NULL, ...)
}
\arguments{
\item{m}{model object}

\item{...}{other arguments to pass}

\item{covariates}{vector of indices for covariates to include in calculation of R2 (default:NULL
means include all covariates by default). When non-null, all covariates not specified are set
to zero for prediction.}

\item{components}{vector of indices for components of the GP model to include in the calculation of R2, i.e. which
elements in the list of Theta/Gamma should be used for calculating R2 (default:NULL
means to include all components by default). When non-null, all components not specified are removed
for prediction.}
}
\value{
vector
}
\description{
Generic Method to Calculate R2 for Fitted Model
}
\details{
Calculates Posterior over Linear Model R2 as: \deqn{1-\frac{SS_{res}}{SS_{tot}}}{1-(SS_(res)/SS_(tot))} where
  \eqn{SS} is defined in terms of trace of variances

  Method of calculating R2 is multivariate version of the Bayesian R2 proposed
  by Gelman, Goodrich, Gabry, and Vehtari, 2019

Calculates Posterior over Basset Model R2 as:
  \deqn{1-\frac{SS_{res}}{SS_{tot}}}{1-(SS_(res)/SS_(tot))}

  Method of calculating R2 is multivariate version of the Bayesian R2 proposed
  by Gelman, Goodrich, Gabry, and Vehtari, 2019
}
