% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design.R
\name{fhir_save_design}
\alias{fhir_save_design}
\title{Write design to xml}
\usage{
fhir_save_design(design, file = "design.xml")
}
\arguments{
\item{design}{A \linkS4class{fhir_design} object. See \code{\link[=fhir_design]{fhir_design()}}.}

\item{file}{A string specifying the file to write to, defaults to writing 'design.xml'
into the current working directory.}
}
\description{
Writes a \linkS4class{fhir_design} for use with \code{\link[=fhir_crack]{fhir_crack()}} to an xml file.
}
\examples{
#create and save design
table_desc1 <- fhir_table_description(
    resource = 'Patient',
    cols     = c(
        id     = 'id',           # column names with xpaths
        name   = 'name/family',
        gender = 'gender'
    ),
    sep           = ':::',
    brackets      = c('[', ']'),
    rm_empty_cols = FALSE,
    format        = 'compact',
    keep_attr     = FALSE
)

table_desc2 <- fhir_table_description(
    resource = 'Observation',
    cols     = c(
        'code/coding/system', # only xpaths
        'code/coding/code'
    )
)

design <- fhir_design(
    Patients     = table_desc1,
    Observations = table_desc2
)

fhir_save_design(design = design, file = tempfile())
}
\seealso{
\code{\link[=fhir_design]{fhir_design()}}, \code{\link[=fhir_table_description]{fhir_table_description()}}, \code{\link[=fhir_load_design]{fhir_load_design()}}
}
