% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pfpca.R
\name{pfpca}
\alias{pfpca}
\title{Partially Separable Karhunen-Loeve Expansion}
\usage{
pfpca(y, t = seq(0, 1, length.out = dim(y[[1]])[2]))
}
\arguments{
\item{y}{list of length p containing densely observed multivariate (p-dimensional) functional data . \code{y[[j]]} is an nxm matrix of functional data for n subjects observed on a grid of length m}

\item{t}{(optional) grid on which functional data is observed, defaults to seq(0, 1, m) where \code{m = dim(data[[1]])[2]}}
}
\value{
A list with three variables:
\describe{
  \item{\code{phi}}{Lxm matrix where each row denotes the value of a basis function evaluated at a grid of length m}
  \item{\code{theta}}{list of length L of functional principal component scores. \code{theta[[l]]} is an nxp matrix of vector scores corresponding to the basis function \code{phi[l,]}}
  \item{\code{FVE}}{fraction of functional variance explained (FVE) by the first L components}
}
}
\description{
Estimates the Karhunen-Loeve expansion for a partially separable multivariate Gaussian process.
}
\details{
This function implements the functional graphical model in Zapata, Oh, and Petersen (2019).
This code uses functions from the testing version of fdapace available at: \url{https://github.com/functionaldata/tPACE}.
}
\examples{
## Variables
# Omega - list of precision matrices, one per eigenfunction
# Sigma - list of covariance matrices, one per eigenfunction
# theta - list of functional  principal component scores
# phi - list of eigenfunctions densely observed on a time grid
# y - list containing densely observed multivariate (p-dimensional) functional data 

library(mvtnorm)
library(fda)

## Generate data y
 source(system.file("exec", "getOmegaSigma.R", package = "fgm"))
 theta = lapply(1:nbasis, function(b) t(rmvnorm(n = 100, sigma = Sigma[[b]])))
 theta.reshaped = lapply( 1:p, function(j){
     t(sapply(1:nbasis, function(i) theta[[i]][j,]))
 })
 phi.basis=create.fourier.basis(rangeval=c(0,1), nbasis=21, period=1)
 t = seq(0, 1, length.out = time.grid.length)
 chosen.basis = c(2, 3, 6, 7, 10, 11, 16, 17, 20, 21)
 phi = t(predict(phi.basis, t))[chosen.basis,]
 y = lapply(theta.reshaped, function(th) t(th)\%*\%phi)
 
## Solve  
 pfpca(y)

}
\references{
Zapata J., Oh S. and Petersen A. (2019) - Partial Separability and Functional Graphical Models for Multivariate Gaussian Processes. Available at \url{https://arxiv.org/abs/1910.03134}.
}
\author{
Javier Zapata, Sang-Yun Oh and Alexander Petersen
}
\keyword{components}
\keyword{fda}
\keyword{fpca}
\keyword{partial}
\keyword{pca}
\keyword{pfpca}
\keyword{principal}
\keyword{separability}
