% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nms_manipulate_names.R
\name{nms_try_rename}
\alias{nms_try_rename}
\title{Try to rename an object.}
\usage{
nms_try_rename(x, want, try)
}
\arguments{
\item{x}{A named object.}

\item{want}{String of length 1 giving the name you want the object to have.}

\item{try}{String of length 1 giving the name the object might have.}
}
\description{
Given a name you want and a possible alternative, this function renames an
object as you want or errs with an informative message.
}
\examples{
nms_try_rename(c(a = 1), "A", "a")
nms_try_rename(data.frame(a = 1), "A", "a")

# Passes
nms_try_rename(c(a = 1, 1), "A", "a")
\dontrun{
# Errs
# nms_try_rename(1, "A", "A")
}

}
\seealso{
nms

Other functions for developers: \code{\link{check_crucial_names}},
  \code{\link{extract_insensitive}},
  \code{\link{flag_if_group}}, \code{\link{is_multiple}},
  \code{\link{rename_matches}}, \code{\link{type_ensure}}
}
\concept{functions dealing with names}
\concept{functions for developers}
\keyword{internal}
