% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fgeo_habitat.R
\name{fgeo_habitat}
\alias{fgeo_habitat}
\title{Create habitat data from measures of topography.}
\usage{
fgeo_habitat(elev, gridsize, n, ...)
}
\arguments{
\item{elev}{One of these:
\itemize{
\item A dataframe containing elevation data, with columns \code{gx}, \code{gy}, and
\code{elev}, or \code{x}, \code{y}, and \code{elev} (e.g. \code{fgeo.x::elevation$col}).
\item A ForestGEO-like elevation list with elements \code{xdim} and \code{ydim} giving
plot dimensions, and element \code{col} containing a dataframe as described in
the previous item (e.g. \code{fgeo.x::elevation}).
}}

\item{gridsize}{Number giving the size of each quadrat for which a habitat
is calculated. Commonly, \code{gridsize = 20}.}

\item{n}{Integer. Number of cluster-groups to construct (passed to the
argument \code{k} to \code{\link[stats:cutree]{stats::cutree()}}).}

\item{...}{Arguments passed to \code{\link[=fgeo_topography]{fgeo_topography()}}.}
}
\value{
A dataframe of subclass fgeo_habitat, with columns \code{gx} and \code{gy},
rounded with accuracy determined by \code{gridsize}, and column \code{habitats}, with
as many distinct integer values as determined by the argument \code{n}.
}
\description{
This function constructs habitat data based on elevation data. It calculates
habitats in two steps:
\enumerate{
\item It calculates mean elevation, convexity and slope for each quadrat.
\item It calculates habitats based on hierarchical clustering of the topographic
metrics from step 1.
}
}
\examples{
assert_is_installed("fgeo.x")

# Input a ForestGEO-like elevation list or dataframe
elevation_ls <- fgeo.x::elevation
habitats <- fgeo_habitat(
  elevation_ls,
  gridsize = 20, n = 4
)

str(habitats)

# Habitat data is useful for calculating species-habitat associations
census <- fgeo.x::tree6_3species
as_tibble(
  tt_test(census, habitats)
)
}
\seealso{
\code{fgeo.plot::autoplot.fgeo_habitat()}, \code{\link[=fgeo_topography]{fgeo_topography()}}.

Other habitat functions: \code{\link{fgeo_topography}},
  \code{\link{tt_test}}

Other functions to construct fgeo classes: \code{\link{fgeo_topography}}
}
\author{
Richard Condit.
}
\concept{functions to construct fgeo classes}
\concept{habitat functions}
