% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ffmanova.R, R/rotationtest.R
\name{rotationtests}
\alias{rotationtests}
\alias{rotationtest}
\title{Rotation testing}
\usage{
rotationtests(xyObj, nSim, verbose = TRUE)

rotationtest(modelData, errorData, simN = 999, dfE = -1,
  dispsim = TRUE)
}
\arguments{
\item{xyObj}{a design-with-responses object created by \code{\link{xy_Obj}}}

\item{nSim}{vector of nonnegative integers.  The number of simulations to
use for each term.}

\item{verbose}{logical.  Whether \code{rotationtests} (and
\code{rotationtest}) should be verbose.}

\item{modelData}{matrix of hypothesis observations}

\item{errorData}{matrix of error observations}

\item{simN}{Number of simulations for each test. Can be a single value or a
list of values for each term.}

\item{dfE}{Degrees of freedom for error needs to be specified if
\code{errorData} is incomplete}

\item{dispsim}{When \code{TRUE}, dots are displayed to illustrate simulation
progress.}
}
\value{
Both functions return a list with components
\item{pAdjusted}{adjusted \eqn{p}-values according to familywise error
rates} \item{pAdjFDR}{adjusted \eqn{p}-values according to false discovery
rates} \item{simN}{number of simulations performed for each term}
}
\description{
The functions perform rotation testing based on a matrix of hypothesis
observations and a matrix of error observations. Adjusted \eqn{p}-values
according to familywise error rates and false discovery rates are
calculated.
}
\details{
\code{modelData} and \code{errorObs} correspond to \code{hypObs} and
\code{errorObs} calculated by \code{xy_Obj}. These matrices are efficient
representations of sums of squares and cross-products (see
\code{\link{xy_Obj}} for details). This means that \code{rotationtest} can
be viewed as a generalised \eqn{F}-test function.

\code{rotationtests} is a wrapper function that calls \code{rotationtest}
for each term in the \code{xyObj} and collects the results.
}
\references{
Langsrud, Ø. (2005) Rotation Tests. \emph{Statistics and
Computing}, \bold{15}, 53--60.

Moen, B., Oust, A., Langsrud, Ø., Dorrell, N., Gemma, L., Marsden, G.L.,
Hinds, J., Kohler, A., Wren, B.W. and Rudi, K. (2005) An explorative
multifactor approach for investigating global survival mechanisms of
Campylobacter jejuni under environmental conditions.  \emph{Applied and
Environmental Microbiology}, \bold{71}, 2086-2094.
}
\seealso{
\code{\link{unitest}}, \code{\link{unitests}}
}
\author{
Øyvind Langsrud and Bjørn-Helge Mevik
}
\keyword{htest}
