% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/best.R
\name{best_roster}
\alias{best_roster}
\title{Sort the optimal fantasy roster}
\usage{
best_roster(
  leagueId = ffl_id(),
  useScore = c("actualScore", "projectedScore"),
  scoringPeriodId = NULL,
  ...
)
}
\arguments{
\item{leagueId}{Numeric league ID or ESPN fantasy page URL. Defaults to
\code{getOption("fflr.leagueId")}. Function fails if no ID is found.}

\item{useScore}{One of "projectedScore" or "actualScore" (default).}

\item{scoringPeriodId}{Integer week of NFL season. By default, \code{NULL} will
use the current week (see \code{\link[=ffl_week]{ffl_week()}}). Scoring periods are always one
week in length, whereas matchups might be longer.}

\item{...}{Additional queries passed to \code{\link[httr:GET]{httr::GET()}}. Arguments are
converted to a named list and passed to \code{query} alongside \code{view}.}
}
\value{
A dataframe (or list) with optimal rosters.
}
\description{
Uses the roster settings for each league to find the best possible
combinations of players to score the most fantasy points.
}
\details{
If \code{scoringPeriodId} is the current week (the default), then actual scoring
might be incomplete (see \code{projectedScore} argument).
}
\examples{
best_roster(leagueId = "42654852", scoringPeriodId = 1)
}
\seealso{
Other roster functions: 
\code{\link{roster_score}()},
\code{\link{start_roster}()},
\code{\link{team_roster}()}
}
\concept{roster functions}
