% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-sample-lmoments.R
\name{utils_sample_lmoments}
\alias{utils_sample_lmoments}
\title{Sample L-moments}
\usage{
utils_sample_lmoments(data)
}
\arguments{
\item{data}{Numeric vector of observed annual maximum series values.
Must be strictly positive, finite, and not missing.}
}
\value{
A numeric vector containing the first four sample L-moments and L-moment ratios:
\itemize{
\item \eqn{l_1}: L-mean
\item \eqn{l_2}: L-variance
\item \eqn{t_3}: L-skewness
\item \eqn{t_4}: L-kurtosis
}
}
\description{
Computes the first four sample L-moments and L-moment ratios from a numeric
vector of data. L-moments are linear combinations of order statistics that
provide robust alternatives to conventional moments, with advantages in
parameter estimation for heavy-tailed and skewed distributions.
}
\details{
Given probability weighted moments \eqn{\beta_0, \beta_1, \beta_2, \beta_3},
the first four sample L-moments are:
\itemize{
\item \eqn{l_1 = \beta_0}
\item \eqn{l_2 = 2\beta_1 - \beta_0}
\item \eqn{l_3 = 6\beta_2 - 6\beta_1 + \beta_0}
\item \eqn{l_4 = 20\beta_3 - 30\beta_2 + 12\beta_1 - \beta_0}
}

Then, the sample L-skewness is \eqn{t_3 = l_3 / l_2} and the sample L-kurtosis
is \eqn{t_4 = l_4 / l_2}.
}
\examples{
data <- rnorm(n = 100, mean = 100, sd = 10)
utils_sample_lmoments(data)

}
\references{
Hosking, J. R. M. (1990). L-moments: Analysis and estimation of distributions
using linear combinations of order statistics. \emph{Journal of the Royal Statistical
Society: Series B (Methodological)}, 52(1), 105–124.
}
