% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit-lmoments.R
\name{fit_lmoments}
\alias{fit_lmoments}
\title{L-Moments Parameter Estimation}
\usage{
fit_lmoments(data, distribution)
}
\arguments{
\item{data}{Numeric vector of observed annual maximum series values.
Must be strictly positive, finite, and not missing.}

\item{distribution}{A three-character code indicating the distribution family.
Must be \code{"GUM"}, \code{"NOR"}, \code{"LNO"}, \code{"GEV"}, \code{"GLO"}, \code{"GNO"}, \code{"PE3"}, \code{"LP3"},
or \code{"WEI"}.}
}
\value{
A list containing the results of parameter estimation:
\itemize{
\item \code{data}: The \code{data} argument.
\item \code{distribution}: The \code{distribution} argument.
\item \code{method}: \code{"L-moments"}.
\item \code{params}: Numeric vector of estimated parameters.
}
}
\description{
\strong{For S-FFA only}: Estimates the parameters of a \emph{stationary} probability model
using the L-moments.
}
\details{
First, the sample L-moments of the data are computed using \code{\link[=utils_sample_lmoments]{utils_sample_lmoments()}}.
Then, formulas from Hosking (1997) are used to match the parameters to
the sample L-moments. The distributions \code{"GNO"}, \code{"PE3"}, and \code{"LP3"} use a
rational approximation of the parameters since no closed-form expression is known.
}
\examples{
data <- rnorm(n = 100, mean = 100, sd = 10)
fit_lmoments(data, "GUM")

}
\references{
Hosking, J.R.M. & Wallis, J.R., 1997. Regional frequency analysis: an approach based
on L-Moments. Cambridge University Press, New York, USA.
}
\seealso{
\code{\link[=fit_lmoments_kappa]{fit_lmoments_kappa()}}, \code{\link[=fit_mle]{fit_mle()}}, \code{\link[=fit_gmle]{fit_gmle()}}
}
