% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.R
\name{get_anchor}
\alias{get_anchor}
\title{Extract the anchor points on the geodesic path}
\usage{
get_anchor(dt, group = NULL)
}
\arguments{
\item{dt}{a data object collected by the projection pursuit guided tour optimisation in the \code{tourr} package}

\item{group}{the variable to label different runs of the optimiser(s)}
}
\value{
a tibble object containing the target bases in each iteration
}
\description{
Extract the anchor points on the geodesic path
}
\examples{
holes_1d_better \%>\% get_anchor()
holes_1d_geo \%>\% get_anchor()
}
\seealso{
Other get functions: 
\code{\link{get_basis_matrix}()},
\code{\link{get_best}()},
\code{\link{get_dir_search}()},
\code{\link{get_interp_last}()},
\code{\link{get_interp}()},
\code{\link{get_interrupt}()},
\code{\link{get_search_count}()},
\code{\link{get_search}()},
\code{\link{get_space_param}()},
\code{\link{get_start}()},
\code{\link{get_theo}()}
}
\concept{get functions}
