% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feasible_point.R
\name{is_feasible_point}
\alias{is_feasible_point}
\title{Determine If A Point Is In Ellipse Overlap}
\usage{
is_feasible_point(point, ell)
}
\arguments{
\item{point}{a numeric of length equal to the dimensions of the ellipses in
\code{ell}.}

\item{ell}{a list of at least one ellipse; see \code{\link{wrangle_ellipse}}.}
}
\value{
\code{is_feasible_point} returns an object of
  \code{\link[base]{class}} "\code{is_feasible_point}". This object is a list
  containing the following components:
  \item{point }{ the inputted \code{point}.}
  \item{fasible }{ logical; is \code{TRUE} when the point \code{x} is in the
    interior of all ellipses.}
  \item{distance }{ a data.frame with the distance from \code{x} to the center
    of each ellipse, the radius of each ellipse and a logical indicator,
    which is \code{TRUE} when \code{x} is an element in the ellipse.}
  \item{call }{ the match call.}
}
\description{
\code{is_feasible_point} will determine if a given point is in the interior
of the intersection of one or more fully specified ellipes.
}
\details{
Given a point \code{is_feasible_point} will check if this point is in the
intersection of the list of ellipses \code{ell}. Note that this function will
not check if the intersection is non-empty.
}
\examples{
e1 <- list("c" = c(1,1), "P" = matrix(c(3,1,1,2), ncol = 2), "r" = 2)
e2 <- list("c" = c(0,2), "S" = matrix(c(4,1,1,1), ncol = 2), "r" = 3)

is_feasible_point(c(1.1,0.9), e1)
is_feasible_point(c(1,0), list(e1, e2))

}
\seealso{
\code{\link{wrangle_ellipse}} for detailed on ellipse
parameterization.
}
