% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text.R
\name{plotzipf}
\alias{plotzipf}
\title{Plot rank versus frequency}
\usage{
plotzipf(d)
}
\arguments{
\item{d}{The corpus of documents (a vector of characters) or the vocabulary of the documents (result of function \code{getvocab}).}
}
\description{
Plot the frequency of words in a document agains the ranks of those words. It also plot the Zipf law.
}
\examples{
\dontrun{
text = loadtext ("http://mattmahoney.net/dc/text8.zip")
plotzipf (text)
vocab = getvocab (text, mincount = 1, lang = NULL)
plotzipf (vocab)
}
}
\seealso{
\code{\link{plotcloud}}, \code{\link{getvocab}}
}
