% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curve_to_q.R
\name{curve_to_q}
\alias{curve_to_q}
\title{Convert to SRVF space}
\usage{
curve_to_q(beta, scale = TRUE)
}
\arguments{
\item{beta}{either a matrix of shape \eqn{n \times T} describing curve or
multidimensional functional data in \eqn{R^n}, where \eqn{n} is the dimension
and \eqn{T} is the number of time points}

\item{scale}{scale curve to unit length (default = \code{TRUE})}
}
\value{
a numeric array of the same shape as the input array \code{beta} storing the
SRVFs of the original curves.
}
\description{
This function converts curves or multidimesional functional data to SRVF
}
\examples{
q <- curve_to_q(beta[, , 1, 1])$q
}
\references{
Srivastava, A., Klassen, E., Joshi, S., Jermyn, I., (2011).
Shape analysis of elastic curves in euclidean spaces. Pattern Analysis and M
achine Intelligence, IEEE Transactions on 33 (7), 1415-1428.
}
\keyword{alignment}
\keyword{srvf}
